from django.urls import path, re_path
from django.conf import settings
from django.conf.urls.static import static

from . import views

urlpatterns = [
    re_path(r'^home/$', views.index, name='home'),
    re_path(r'^crypto/', views.crypto, name='crypto'),
    re_path(r'^pictures/$', views.pictures, name='pictures'),
    re_path(r'^portfolio/$', views.portfolio, name='portfolio'),
    path('', views.index, name='not found'),
] + static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)